/****** Object:  StoredProcedure [dbo].[P_ATUALIZA_EST_PROD_MIX_AGD_BLOQUEIO]    Script Date: 02/26/2014 19:52:06 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_ATUALIZA_EST_PROD_MIX_AGD_BLOQUEIO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_ATUALIZA_EST_PROD_MIX_AGD_BLOQUEIO]
GO
GO 
--EXEC P_ATUALIZA_EST_PROD_MIX_AGD_BLOQUEIO 1,33,1
--Procedure para atualizao de bloqueio de mix
CREATE  PROCEDURE [dbo].[P_ATUALIZA_EST_PROD_MIX_AGD_BLOQUEIO] @CD_EMP INT,@CD_BLOQUEIO INT=0, @ATIVA_DESATIVA TINYINT=1
	WITH ENCRYPTION AS  
CREATE TABLE #ProcBloqueio (CD_EMP INT,
					   CD_FILIAL INT,
					   CD_PROD INT)

INSERT INTO #ProcBloqueio
SELECT  
    EST_PROD_MIX_AGD_BLOQUEIO_FILIAL.CD_EMP,
    EST_PROD_MIX_AGD_BLOQUEIO_FILIAL.CD_FILIAL,
    EST_PROD_MIX_AGD_BLOQUEIO_IT.CD_PROD  
FROM 
    EST_PROD_MIX_AGD_BLOQUEIO_FILIAL INNER JOIN EST_PROD_MIX_AGD_BLOQUEIO_IT ON
    EST_PROD_MIX_AGD_BLOQUEIO_FILIAL.CD_CTR = EST_PROD_MIX_AGD_BLOQUEIO_IT.CD_CTR 
WHERE
    EST_PROD_MIX_AGD_BLOQUEIO_FILIAL.CD_CTR=@CD_BLOQUEIO


DECLARE @filial INT;

Print 'Atualizando bloqueio dos produtos mix  Time '+ convert(varchar,getdate(),108)

Declare cAplicaBlq cursor fast_forward read_only
for
select distinct 
	CD_FILIAL
from
	#ProcBloqueio 
		order by cd_filial;

OPEN cAplicaBlq 
FETCH NEXT from cAplicaBlq  INTO @filial
	WHILE @@FETCH_STATUS=0
	  begin
		Print 'Atualizando bloqueio ' + convert(varchar(10), @CD_BLOQUEIO) + ' Filial '  + convert(varchar(10),@filial);

		UPDATE p
		SET
		  STS_PROD= CASE WHEN @ATIVA_DESATIVA= 1 THEN 2 ELSE 0 END
		FROM 
			EST_PROD_CPL p
			INNER JOIN 	#ProcBloqueio r  ON
			P.CD_EMP     =  R.CD_EMP AND
			P.CD_FILIAL  =  R.CD_FILIAL AND
			P.CD_PROD    =  R.CD_PROD 
		where
			p.cd_emp=@cd_emp
			AND P.CD_FILIAL=@filial;
			
		FETCH NEXT from cAplicaBlq  INTO @filial;
	end

	Close cAplicaBlq  
	Deallocate cAplicaBlq ;

UPDATE
   EST_PROD_MIX_AGD_BLOQUEIO 
SET
    EST_PROD_MIX_AGD_BLOQUEIO.STATUS = CASE WHEN @ATIVA_DESATIVA= 1 THEN 1 ELSE 2 END
WHERE
    EST_PROD_MIX_AGD_BLOQUEIO.CD_CTR = @CD_BLOQUEIO

DROP TABLE #ProcBloqueio

